<?php
/**
 * The template for displaying search forms in Blox Monochrome
 *
 * @package Blox Monochrome
 */
?>
<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search for &hellip;', 'placeholder', 'blox' ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" title="<?php _ex( 'Search for:', 'label', 'blox' ); ?>">
	<input type="submit" class="search-submit button thinButton" value="<?php echo esc_attr_x( 'Search', 'submit button', 'blox' ); ?>">
</form>
